/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.Nullable;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockPartials;
import rbasamoyai.escalated.index.EscalatedSpriteShiftEntries;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class HandrailRenderer
extends SafeBlockEntityRenderer<HandrailBlockEntity> {
    public HandrailRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(HandrailBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState state = be.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof AbstractHandrailBlock)) {
            return;
        }
        AbstractHandrailBlock handrailBlock = (AbstractHandrailBlock)block;
        VertexConsumer vcons = bufferSource.getBuffer(RenderType.solid());
        WalkwaySlope slope = handrailBlock.getHandrailSlope(state);
        boolean end = handrailBlock.isEndHandrail(state);
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)state.getValue(AbstractHandrailBlock.SIDE));
        Direction facing = (Direction)state.getValue((Property)AbstractHandrailBlock.FACING);
        DyeColor handrailColor = be.getHandrailColor();
        PartialModel model = HandrailRenderer.getHandrailModel(slope, end);
        SuperByteBuffer buf = CachedBuffers.partialFacing((PartialModel)model, (BlockState)state, (Direction)facing.getOpposite());
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(handrailColor);
        float scroll = HandrailRenderer.getScrollOffset(be, partialTicks, facing, spriteShift.getTarget().getV0(), spriteShift.getTarget().getV1());
        if (side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH) {
            ms.pushPose();
            Direction left = facing.getCounterClockWise();
            ms.translate((float)(left.getStepX() * 7) / 16.0f, 0.0f, (float)(left.getStepZ() * 7) / 16.0f);
            buf.light(light).shiftUVScrolling(spriteShift, scroll).renderInto(ms, vcons);
            ms.popPose();
        }
        if (side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH) {
            ms.pushPose();
            Direction right = facing.getClockWise();
            ms.translate((float)(right.getStepX() * 7) / 16.0f, 0.0f, (float)(right.getStepZ() * 7) / 16.0f);
            buf.light(light).shiftUVScrolling(spriteShift, scroll).renderInto(ms, vcons);
            ms.popPose();
        }
    }

    public static PartialModel getHandrailModel(WalkwaySlope slope, boolean end) {
        return switch (slope) {
            default -> throw new MatchException(null, null);
            case WalkwaySlope.HORIZONTAL -> EscalatedBlockPartials.HANDRAIL_HORIZONTAL;
            case WalkwaySlope.BOTTOM -> EscalatedBlockPartials.HANDRAIL_BOTTOM;
            case WalkwaySlope.MIDDLE -> EscalatedBlockPartials.HANDRAIL_MIDDLE;
            case WalkwaySlope.TOP -> EscalatedBlockPartials.HANDRAIL_TOP;
            case WalkwaySlope.TERMINAL -> end ? EscalatedBlockPartials.HANDRAIL_END : EscalatedBlockPartials.HANDRAIL_START;
        };
    }

    public static SpriteShiftEntry getSpriteShift(@Nullable DyeColor color) {
        return color == null ? EscalatedSpriteShiftEntries.HANDRAIL : EscalatedSpriteShiftEntries.DYED_HANDRAILS.getOrDefault(color, EscalatedSpriteShiftEntries.HANDRAIL);
    }

    public static float getScrollOffset(HandrailBlockEntity be, float partialTicks, Direction facing, float v0, float v1) {
        float speed = be.getSpeed();
        float stepOffset = be.getVisualProgress() + partialTicks * speed;
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            stepOffset *= -1.0f;
        }
        return (v1 - v0) * (stepOffset += 1.0f) / 3.0f;
    }
}

